/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.D64DriveHandler;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import de.joergjahnke.c64.drive.TapeDriveHandler;
import java.util.Enumeration;

public class Tape2DiskAdapterDriveHandler
extends DiskDriveHandler {
    private static final int[] DISK_ID = new int[]{65, 65};
    private final TapeDriveHandler tapeHandler;
    private D64DriveHandler diskDriveHandler = null;

    public Tape2DiskAdapterDriveHandler(TapeDriveHandler tapeHandler) {
        this.tapeHandler = tapeHandler;
    }

    @Override
    public int getCurrentTrack() {
        return this.getDiskDriveHandler().getCurrentTrack();
    }

    @Override
    public int getCurrentSector() {
        return this.getDiskDriveHandler().getCurrentSector();
    }

    private DiskDriveHandler getDiskDriveHandler() {
        if (this.diskDriveHandler == null) {
            byte[] d64Bytes = new byte[D64DriveHandler.calculateTotalSectors(40) * 256];
            this.diskDriveHandler = new D64DriveHandler();
            this.diskDriveHandler.mount(d64Bytes);
            this.diskDriveHandler.setDiskID(DISK_ID);
            this.diskDriveHandler.format(this.tapeHandler.getLabel(), 0);
            Enumeration en = this.tapeHandler.directoryElements();
            while (en.hasMoreElements()) {
                C64FileEntry entry = (C64FileEntry)en.nextElement();
                byte[] fileBytes = this.readFile(entry);
                this.diskDriveHandler.writeFile(entry.filename, fileBytes);
            }
        }
        return this.diskDriveHandler;
    }

    @Override
    public void mount(byte[] bytes) {
        this.tapeHandler.mount(bytes);
        this.diskDriveHandler = null;
    }

    @Override
    public Enumeration directoryElements() {
        return this.tapeHandler.directoryElements();
    }

    @Override
    public byte[] readFile(C64FileEntry fileEntry) {
        return this.tapeHandler.readFile(fileEntry);
    }

    @Override
    public byte[] readBlockImpl() {
        return this.getDiskDriveHandler().readBlock();
    }

    @Override
    public void writeBlockImpl(byte[] bytes, int numBytes) {
        throw new RuntimeException("Cannot write to tape files!");
    }

    @Override
    public void gotoBlock(int track, int sector) {
        this.getDiskDriveHandler().gotoBlock(track, sector);
    }

    @Override
    public int[] getDiskID() {
        return DISK_ID;
    }
}

